<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\SourceSelection;

use Magento\Directory\Model\Region;

class CustomerAddressRegister
{
    /**
     * Customer address from quote
     *
     * @var array
     */
    private $requestData = [];

    /**
     * Destination address for distance algorithm
     *
     * @var array
     */
    private $destinationAddress = [];

    /**
     * @param string $country
     * @param string $postcode
     * @param string $street
     * @param string $region
     * @param string $city
     */
    public function setDestinationAddress(
        string $country = '',
        string $postcode = '',
        string $street = '',
        string $region = '',
        string $city = ''
    ): void {
        $this->destinationAddress = [
            'country' => $country,
            'postcode' => $postcode,
            'street' => $street,
            'region' => $region,
            'city' => $city
        ];
    }

    /**
     * @return array|null
     */
    public function getDestinationAddress(): ?array
    {
        return $this->destinationAddress;
    }

    /**
     * @param array $address
     *
     * @return void
     */
    public function setDestinationAddressFromRequest(array $requestData): void
    {
        $this->requestData = $requestData;

        $this->setDestinationAddress(
            (string)$requestData['dest_country_id'],
            (string)$requestData['dest_postcode'],
            (string)$requestData['dest_street'],
            (string)$requestData['dest_region_code'],
            (string)$requestData['dest_city']
        );
    }
}
