<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\SourceSelection;

use Amasty\AdvancedMSI\Model\ConfigProvider;

/**
 * Class CombinedAlgorithmData used to prepare algorithms data
 */
class CombinedAlgorithmData
{
    /**
     * @var array
     */
    private $data;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ConfigProvider $configProvider,
        string $class = '',
        string $label = '',
        string $code = '',
        int $defaultPriority = 0,
        bool $defaultIsActive = true,
        bool $isShouldStop = false
    ) {
        $this->configProvider = $configProvider;
        $this->data = [
            'class' => (string)$class,
            'label' => (string)$label,
            'code' => (string)$code,
            'default_priority' => (int)$defaultPriority,
            'default_is_active' => (bool)$defaultIsActive,
            'is_should_stop' => (bool)$isShouldStop
        ];
    }

    /**
     * @return string
     */
    public function getClass(): string
    {
        return $this->data['class'];
    }

    /**
     * @return string
     */
    public function getLabel(): string
    {
        return $this->data['label'];
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->data['code'];
    }

    /**
     * @return int
     */
    public function getPriority(): int
    {
        if (!isset($this->data['priority'])) {
            $algorithms = $this->configProvider->getCombinedAlgorithmValue();
            if (!isset($algorithms[$this->getCode()]['priority'])) {
                $storedValue = $this->data['default_priority'];
            } else {
                $storedValue = $algorithms[$this->getCode()]['priority'];
            }

            $this->data['priority'] = (int)$storedValue;
        }

        return $this->data['priority'];
    }

    /**
     * @return bool
     */
    public function getIsActive(): bool
    {
        if (!isset($this->data['is_active'])) {
            $algorithms = $this->configProvider->getCombinedAlgorithmValue();
            if (!isset($algorithms[$this->getCode()]['is_active'])) {
                $storedValue = $this->data['default_is_active'];
            } else {
                $storedValue = $algorithms[$this->getCode()]['is_active'];
            }

            $this->data['is_active'] = (bool)$storedValue;
        }

        return $this->data['is_active'];
    }

    /**
     * @return bool
     */
    public function getIsShouldStop(): bool
    {
        return $this->data['is_should_stop'];
    }
}
