<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\SourceSelection\Algorithms\Combined;

class EqualSourcesRegister
{
    /**
     * List of equal sources
     *
     * @var array
     */
    private $eqSources = [];

    /**
     * List of rest sources
     *
     * @var array
     */
    private $restSources = [];

    /**
     * @return array
     */
    public function getEqual(): array
    {
        return $this->eqSources;
    }

    /**
     * @return array
     */
    public function getRest(): array
    {
        return $this->restSources;
    }

    /**
     * @return array
     */
    public function getAll(): array
    {
        return array_merge($this->getEqual(), $this->getRest());
    }

    /**
     * @param array $restSources
     *
     * @return void
     */
    public function setRest(array $restSources): void
    {
        $this->restSources = $restSources;
    }

    /**
     * @param array $equalSources
     *
     * @return void
     */
    public function setEqual(array $equalSources): void
    {
        $this->eqSources = $equalSources;
    }
}
