<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model;

use Amasty\AdvancedMSI\Api\Data\SourceEmailInterface;
use Magento\Framework\Model\AbstractModel;

class SourceEmail extends AbstractModel implements SourceEmailInterface
{
    /**
     * @SuppressWarnings(PHPMD.CamelCaseMethodName)
     */
    protected function _construct()
    {
        parent::_construct();

        $this->_init(\Amasty\AdvancedMSI\Model\ResourceModel\SourceCustomShippingRate::class);
    }

    /**
     * @inheritdoc
     */
    public function getSourceEmailId()
    {
        return $this->_getData(SourceEmailInterface::SOURCE_EMAIL_ID);
    }

    /**
     * @inheritdoc
     */
    public function setSourceEmailId($sourceEmailId)
    {
        $this->setData(SourceEmailInterface::SOURCE_EMAIL_ID, $sourceEmailId);

        return $this;
    }

    /**
     * @inheritdoc
     */
    public function getSourceCode()
    {
        return $this->_getData(SourceEmailInterface::SOURCE_CODE);
    }

    /**
     * @inheritdoc
     */
    public function setSourceCode($sourceCode)
    {
        $this->setData(SourceEmailInterface::SOURCE_CODE, $sourceCode);

        return $this;
    }

    /**
     * @inheritdoc
     */
    public function getEmail()
    {
        return $this->_getData(SourceEmailInterface::EMAIL);
    }

    /**
     * @inheritdoc
     */
    public function setEmail($email)
    {
        $this->setData(SourceEmailInterface::EMAIL, $email);

        return $this;
    }

    /**
     * @inheritdoc
     */
    public function getEmailType()
    {
        return $this->_getData(SourceEmailInterface::EMAIL_TYPE);
    }

    /**
     * @inheritdoc
     */
    public function setEmailType($emailType)
    {
        $this->setData(SourceEmailInterface::EMAIL_TYPE, $emailType);

        return $this;
    }
}
