<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model;

use Amasty\AdvancedMSI\Api\Data\SourceCustomShippingRateInterface;
use Magento\Framework\Model\AbstractModel;

class SourceCustomShippingRate extends AbstractModel implements SourceCustomShippingRateInterface
{
    /**
     * @SuppressWarnings(PHPMD.CamelCaseMethodName)
     */
    protected function _construct()
    {
        parent::_construct();

        $this->_init(\Amasty\AdvancedMSI\Model\ResourceModel\SourceCustomShippingRate::class);
    }

    /**
     * @inheritDoc
     */
    public function getSourceCustomShippingRateId(): int
    {
        return (int)$this->_getData(SourceCustomShippingRateInterface::SOURCE_CUSTOM_RATE_ID);
    }

    /**
     * @inheritDoc
     */
    public function setSourceCustomShippingRateId(int $sourceCustomShippingRateId): SourceCustomShippingRateInterface
    {
        return $this->setData(SourceCustomShippingRateInterface::SOURCE_CUSTOM_RATE_ID, $sourceCustomShippingRateId);
    }

    /**
     * @inheritDoc
     */
    public function getSourceCode(): string
    {
        return $this->_getData(SourceCustomShippingRateInterface::SOURCE_CODE);
    }

    /**
     * @inheritDoc
     */
    public function setSourceCode(string $sourceCode): SourceCustomShippingRate
    {
        return $this->setData(SourceCustomShippingRateInterface::SOURCE_CODE, $sourceCode);
    }

    /**
     * @inheritDoc
     */
    public function getShippingRateCode(): string
    {
        return $this->_getData(SourceCustomShippingRateInterface::SHIPPING_RATE_CODE);
    }

    /**
     * @inheritDoc
     */
    public function setShippingRateCode(string $shippingRateCode): SourceCustomShippingRateInterface
    {
        return $this->setData(SourceCustomShippingRateInterface::SHIPPING_RATE_CODE, $shippingRateCode);
    }

    /**
     * @inheritDoc
     */
    public function getShippingRate(): float
    {
        return (float)$this->_getData(SourceCustomShippingRateInterface::SHIPPING_RATE);
    }

    /**
     * @inheritDoc
     */
    public function setShippingRate(float $shippingRate): SourceCustomShippingRateInterface
    {
        return $this->setData(SourceCustomShippingRateInterface::SHIPPING_RATE, $shippingRate);
    }
}
