<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\ResourceModel\SourceEmail;

use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Amasty\AdvancedMSI\Plugin\InventorySourceUi\SourceDataProvider;
use Amasty\AdvancedMSI\Api\Data\SourceEmailInterface;

class Collection extends AbstractCollection
{
    /**
     * @SuppressWarnings(PHPMD.CamelCaseMethodName)
     */
    public function _construct()
    {
        parent::_construct();
        $this->_init(
            \Amasty\AdvancedMSI\Model\SourceEmail::class,
            \Amasty\AdvancedMSI\Model\ResourceModel\SourceEmail::class
        );
        $this->_setIdFieldName($this->getResource()->getIdFieldName());
    }

    /**
     * @param string $sourceCode
     * @param string $type
     *
     * @return array
     */
    public function getEmailsByType($sourceCode, $type)
    {
        return $this->addFieldToFilter(SourceEmailInterface::EMAIL_TYPE, $type)
            ->addFieldToFilter(SourceEmailInterface::SOURCE_CODE, $sourceCode)
            ->getColumnValues(SourceEmailInterface::EMAIL);
    }
}
