<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\ResourceModel;

use Amasty\AdvancedMSI\Api\Data\SourceEmailInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class SourceEmail extends AbstractDb
{
    public const TABLE_NAME = 'amasty_advanced_msi_source_emails';

    /**
     * @SuppressWarnings(PHPMD.CamelCaseMethodName)
     */
    public function _construct()
    {
        $this->_init(self::TABLE_NAME, SourceEmailInterface::SOURCE_EMAIL_ID);
    }

    public function deleteEmails($type, $sourceCode)
    {
        $this->getConnection()->delete(
            $this->getMainTable(),
            [
                SourceEmailInterface::EMAIL_TYPE . ' = ? ' => $type,
                SourceEmailInterface::SOURCE_CODE . ' = ? ' => $sourceCode
            ]
        );
    }
}
