<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\ResourceModel;

use Amasty\AdvancedMSI\Api\Data\SourceCustomShippingRateInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class SourceCustomShippingRate extends AbstractDb
{
    public const TABLE_NAME = 'amasty_advanced_msi_source_custom_shipping_rates';

    /**
     * @SuppressWarnings(PHPMD.CamelCaseMethodName)
     */
    public function _construct()
    {
        $this->_init(self::TABLE_NAME, SourceCustomShippingRateInterface::SOURCE_CUSTOM_RATE_ID);
    }

    public function deleteBySourceCode($sourceCode)
    {
        $this->getConnection()->delete(
            $this->getMainTable(),
            [SourceCustomShippingRateInterface::SOURCE_CODE. ' = ? ' => $sourceCode]
        );
    }
}
