<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model;

use Magento\Framework\Model\AbstractModel;
use Amasty\AdvancedMSI\Api\Data\ReservedProductsInterface;
use Amasty\AdvancedMSI\Model\ResourceModel\ReservedProducts as ReservedProductsResource;

class ReservedProducts extends AbstractModel implements ReservedProductsInterface
{
    /**
     * @SuppressWarnings(PHPMD.CamelCaseMethodName)
     */
    protected function _construct()
    {
        parent::_construct();

        $this->_init(ReservedProductsResource::class);
    }

    /**
     * {@inheritdoc}
     */
    public function getItemId(): int
    {
        return (int)$this->getData(self::ITEM_ID);
    }

    /**
     * {@inheritdoc}
     */
    public function setItemId($itemId): ReservedProductsInterface
    {
        return $this->setData(self::ITEM_ID, $itemId);
    }

    /**
     * {@inheritdoc}
     */
    public function getSku(): string
    {
        return $this->getData(self::SKU);
    }

    /**
     * {@inheritdoc}
     */
    public function setSku($sku): ReservedProductsInterface
    {
        return $this->setData(self::SKU, $sku);
    }

    /**
     * {@inheritdoc}
     */
    public function getQuantity(): float
    {
        return (float)$this->getData(self::QUANTITY);
    }

    /**
     * {@inheritdoc}
     */
    public function setQuantity($quantity): ReservedProductsInterface
    {
        return $this->setData(self::QUANTITY, $quantity);
    }

    /**
     * {@inheritdoc}
     */
    public function getOrderId(): int
    {
        return $this->getData(self::ORDER_ID);
    }

    /**
     * {@inheritdoc}
     */
    public function setOrderId($orderId): ReservedProductsInterface
    {
        return $this->setData(self::ORDER_ID, $orderId);
    }

    /**
     * {@inheritdoc}
     */
    public function getSourceCode(): string
    {
        return $this->getData(self::SOURCE_CODE);
    }

    /**
     * {@inheritdoc}
     */
    public function setSourceCode($sourceCode): ReservedProductsInterface
    {
        return $this->setData(self::SOURCE_CODE, $sourceCode);
    }
}
