<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\Import\Source\Behaviors;

use Amasty\AdvancedMSI\Plugin\InventorySourceUi\SourceDataProvider;
use Magento\Framework\Validation\ValidationException;
use Magento\Framework\Exception\CouldNotSaveException;

class Add implements \Amasty\Base\Model\Import\Behavior\BehaviorInterface
{
    /**
     * @var \Magento\InventoryApi\Api\SourceRepositoryInterface
     */
    private $sourceRepository;

    /**
     * @var \Magento\InventoryApi\Api\Data\SourceInterfaceFactory
     */
    private $sourceFactory;

    /**
     * @var \Amasty\AdvancedMSI\Api\SourceEmailRepositoryInterface
     */
    private $sourceEmailRepository;

    /**
     * @var \Amasty\AdvancedMSI\Api\SourceCustomShippingRateRepositoryInterface
     */
    private $customShippingRateRepository;

    public function __construct(
        \Magento\InventoryApi\Api\SourceRepositoryInterface $sourceRepository,
        \Magento\InventoryApi\Api\Data\SourceInterfaceFactory $sourceFactory,
        \Amasty\AdvancedMSI\Api\SourceEmailRepositoryInterface $sourceEmailRepository,
        \Amasty\AdvancedMSI\Api\SourceCustomShippingRateRepositoryInterface $customShippingRateRepository
    ) {
        $this->sourceRepository = $sourceRepository;
        $this->sourceFactory = $sourceFactory;
        $this->sourceEmailRepository = $sourceEmailRepository;
        $this->customShippingRateRepository = $customShippingRateRepository;
    }

    /**
     * @param array $importData
     * @param \Amasty\Base\Model\Import\ImportCounter $importCounter
     */
    public function execute(array $importData, $importCounter = null)
    {
        $rateCodes = ['dhl', 'fedex', 'flatrate', 'tablerate', 'freeshipping', 'ups', 'usps'];
        foreach ($importData as $sourceData) {
            $source = $this->sourceFactory->create();
            $source->setData($sourceData);

            try {
                $this->sourceRepository->save($source);
                $importCounter->incrementCreated();
                if (!empty($sourceData['order_email_notification'])) {
                    foreach (explode(',', $sourceData['order_email_notification']) as $email) {
                        $email = $this->sourceEmailRepository->getEmptySourceEmailModel()
                            ->setEmail(trim($email))
                            ->setEmailType(SourceDataProvider::SHIPMENT_EMAILS)
                            ->setSourceCode($source->getSourceCode());
                        if (!empty($email->getEmail())) {
                            $this->sourceEmailRepository->save($email);
                        }
                    }
                }
                if (!empty($sourceData['low_stock_notification'])) {
                    foreach (explode(',', $sourceData['low_stock_notification']) as $email) {
                        $email = $this->sourceEmailRepository->getEmptySourceEmailModel()
                            ->setEmail(trim($email))
                            ->setEmailType(SourceDataProvider::LOW_STOCK_EMAILS)
                            ->setSourceCode($source->getSourceCode());
                        if (!empty($email->getEmail())) {
                            $this->sourceEmailRepository->save($email);
                        }
                    }
                }

                $importRates = [];
                foreach ($rateCodes as $carrier) {
                    if (isset($sourceData[$carrier]) && $sourceData[$carrier] !== '') {
                        $importRates[$carrier] = $sourceData[$carrier];
                    }
                }
                if (!empty($importRates)) {
                    $rates = [];
                    foreach ($importRates as $carrier => $rate) {
                        $rates[] = $this->customShippingRateRepository->getEmptySourceCustomShippingRateModel()
                            ->setShippingRateCode($carrier)
                            ->setSourceCode($source->getSourceCode())
                            ->setShippingRate((float)$rate);
                    }
                    $this->customShippingRateRepository->save($source->getSourceCode(), $rates);
                }
            } catch (CouldNotSaveException $e) {
                null;
            } catch (ValidationException $e) {
                null;
            }
        }
    }
}
