<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */
namespace Amasty\AdvancedMSI\Model;

use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface;

class GetSourcesBySourceSelectionResult
{
    /**
     * Get all sources and sort them by availability, return source codes
     *
     * @param SourceSelectionResultInterface $sourceSelectionResult
     *
     * @return array
     */
    public function execute(SourceSelectionResultInterface $sourceSelectionResult): array
    {
        $sourceSortWeight = $sources = [];

        foreach ($sourceSelectionResult->getSourceSelectionItems() as $item) {
            $sourceCode = $item->getSourceCode();
            if (!isset($sourceSortWeight[$sourceCode])) {
                $sourceSortWeight[$sourceCode] = 0;
            }
            $sourceSortWeight[$sourceCode] += (int)($item->getQtyToDeduct() > 0);
        }

        arsort($sourceSortWeight);

        return array_keys($sourceSortWeight);
    }
}
