<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\Config\Source\Email;

use Magento\Email\Model\ResourceModel\Template\CollectionFactory;
use Magento\Email\Model\Template\Config;
use Magento\Framework\DataObject;
use Magento\Framework\Registry;

class Template extends DataObject
{
    public const EMAIL_TEMPLATE_PREFIX = 'amasty_advanced_msi_email_';
    public const LOW_STOCK_TEMPLATE_ID = 'low_stock';
    public const SHIPMENT_TEMPLATE_ID = 'shipment';

    /**
     * @var Registry
     */
    private $coreRegistry;

    /**
     * @var Config
     */
    private $emailConfig;

    /**
     * @var CollectionFactory
     */
    private $templatesFactory;

    public function __construct(
        CollectionFactory $templatesFactory,
        Registry $coreRegistry,
        Config $emailConfig,
        array $data = []
    ) {
        parent::__construct($data);
        $this->templatesFactory = $templatesFactory;
        $this->coreRegistry = $coreRegistry;
        $this->emailConfig = $emailConfig;
    }

    public function toOptionArray(): array
    {
        $templatePath = explode('/', $this->getData('path'));
        $templateId = self::EMAIL_TEMPLATE_PREFIX . end($templatePath);
        $collection = $this->templatesFactory->create();
        $collection->addFieldToFilter('orig_template_code', $templateId);
        $options = $collection->toOptionArray();
        $templateLabel = $this->emailConfig->getTemplateLabel($templateId);
        $templateLabel = __('%1 (Default)', $templateLabel);
        array_unshift($options, ['value' => $templateId, 'label' => $templateLabel]);

        return $options;
    }
}
