<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Model\Config;

use Magento\InventorySourceSelectionApi\Api\GetSourceSelectionAlgorithmListInterface;

class AvailableSourceList implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @var GetSourceSelectionAlgorithmListInterface
     */
    private $getSourceSelectionAlgorithmListInterface;

    /**
     * AvailableSourceList constructor.
     * @param GetSourceSelectionAlgorithmListInterface $getSourceSelectionAlgorithmList
     */
    public function __construct(GetSourceSelectionAlgorithmListInterface $getSourceSelectionAlgorithmList)
    {
        $this->getSourceSelectionAlgorithmListInterface = $getSourceSelectionAlgorithmList;
    }

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        $values = [];
        $algorithms = $this->getSourceSelectionAlgorithmListInterface->execute();
        foreach ($algorithms as $algorithm) {
            $values[] = [
                'value' => $algorithm->getCode(),
                'label' => $algorithm->getTitle()
            ];
        }

        return $values;
    }
}
