<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Controller\Adminhtml\Source;

use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;
use Magento\InventoryApi\Api\Data\SourceItemInterface;

class RemoveProduct extends \Magento\Backend\App\Action
{
    public const ADMIN_RESOURCE = 'Magento_InventoryApi::source';

    /**
     * @var \Magento\InventoryApi\Api\SourceItemsDeleteInterface
     */
    private $sourceItemsDelete;

    /**
     * @var \Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory
     */
    private $sourceItemFactory;

    /**
     * @var \Magento\Ui\Component\MassAction\Filter
     */
    private $filter;

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        Action\Context $context,
        \Magento\Ui\Component\MassAction\Filter $filter,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory,
        \Magento\InventoryApi\Api\SourceItemsDeleteInterface $sourceItemsDelete,
        \Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory $sourceItemFactory
    ) {
        parent::__construct($context);
        $this->sourceItemsDelete = $sourceItemsDelete;
        $this->sourceItemFactory = $sourceItemFactory;
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
    }

    public function execute()
    {
        $sourceCode = $this->getRequest()->getParam('source_code');
        $sku = $this->getRequest()->getParam('sku');

        if (empty($sourceCode) || empty($sku)) {
            return $this->resultRedirectFactory->create()->setRefererUrl();
        }

        $model = $this->sourceItemFactory->create();
        $model->setStatus(SourceItemInterface::STATUS_IN_STOCK);
        $model->setSourceCode($sourceCode);
        $model->setQuantity(0);
        $model->setSku($sku);

        $this->sourceItemsDelete->execute([$model]);

        $this->messageManager->addSuccessMessage(
            __('%1 product(s) have been successfully removed from the source', 1)
        );

        return $this->resultRedirectFactory->create()->setRefererUrl();
    }
}
