<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Controller\Adminhtml\Source;

use Magento\Backend\App\Action;
use Magento\Framework\DB\Select;
use Magento\InventoryApi\Api\Data\SourceItemInterface;
use Magento\Framework\App\Response\RedirectInterface;

class Remove extends \Magento\Backend\App\Action
{
    public const ADMIN_RESOURCE = 'Magento_InventoryApi::source';

    /**
     * @var \Magento\InventoryApi\Api\SourceItemsDeleteInterface
     */
    private $sourceItemsDelete;

    /**
     * @var \Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory
     */
    private $sourceItemFactory;

    /**
     * @var \Magento\Ui\Component\MassAction\Filter
     */
    private $filter;

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var RedirectInterface
     */
    private $redirect;

    public function __construct(
        Action\Context $context,
        \Magento\Ui\Component\MassAction\Filter $filter,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory,
        \Magento\InventoryApi\Api\SourceItemsDeleteInterface $sourceItemsDelete,
        \Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory $sourceItemFactory,
        RedirectInterface $redirect
    ) {
        parent::__construct($context);
        $this->sourceItemsDelete = $sourceItemsDelete;
        $this->sourceItemFactory = $sourceItemFactory;
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        $this->redirect = $redirect;
    }

    public function execute()
    {
        $sourceCode = $this->getRequest()->getParam('source_code');

        if (empty($sourceCode)) {
            return $this->resultRedirectFactory->create()->setPath($this->redirect->getRefererUrl());
        }

        $this->getRequest()->setParams(
            array_merge(
                $this->getRequest()->getParams(),
                ['namespace' => 'ammsi_source_product_listing']
            )
        );
        $component = $this->filter->getComponent();
        $this->filter->prepareComponent($component);
        $collection = $this->filter->getCollection($component->getContext()->getDataProvider()->getCollection());
        $collection->setPageSize(null);

        $sourceItems = [];
        $collection->getSelect()
            ->reset(Select::COLUMNS)
            ->columns(['sku']);
        foreach ($collection->getData() as $item) {
            $model = $this->sourceItemFactory->create();
            $model->setStatus(SourceItemInterface::STATUS_IN_STOCK);
            $model->setSourceCode($sourceCode);
            $model->setQuantity(0);
            $model->setSku($item['sku']);

            $sourceItems[] = $model;
        }

        $this->sourceItemsDelete->execute($sourceItems);

        if (!empty($sourceItems)) {
            $this->messageManager->addSuccessMessage(
                __('%1 product(s) have been successfully removed from the source', count($sourceItems))
            );
        }

        return $this->resultRedirectFactory->create()->setPath($this->redirect->getRefererUrl());
    }
}
