<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Controller\Adminhtml\Source;

use Magento\Backend\App\Action;
use Magento\Catalog\Model\Indexer\Product\Full;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Magento\Framework\DB\Select;
use Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory;
use Magento\InventoryApi\Api\SourceItemsSaveInterface;
use Magento\InventoryLowQuantityNotificationApi\Api\Data\SourceItemConfigurationInterfaceFactory;
use Magento\InventoryLowQuantityNotificationApi\Api\DeleteSourceItemsConfigurationInterface;
use Magento\InventoryLowQuantityNotificationApi\Api\SourceItemConfigurationsSaveInterface;

class InlineEdit extends \Magento\Backend\App\Action
{
    public const ADMIN_RESOURCE = 'Magento_InventoryApi::source';

    /**
     * @var SourceItemsSaveInterface
     */
    private $sourceItemsSave;

    /**
     * @var SourceItemInterfaceFactory
     */
    private $sourceItemFactory;

    /**
     * @var SourceItemConfigurationsSaveInterface
     */
    private $sourceItemConfigurationsSave;

    /**
     * @var DeleteSourceItemsConfigurationInterface
     */
    private $deleteSourceItemsConfiguration;

    /**
     * @var SourceItemConfigurationInterfaceFactory
     */
    private $sourceItemConfigurationInterfaceFactory;

    /**
     * @var CollectionFactory
     */
    private $productCollectionFactory;

    /**
     * @var Full
     */
    private $indexer;

    public function __construct(
        Action\Context $context,
        SourceItemsSaveInterface $sourceItemsSave,
        SourceItemInterfaceFactory $sourceItemFactory,
        SourceItemConfigurationsSaveInterface $sourceItemConfigurationsSave,
        DeleteSourceItemsConfigurationInterface $deleteSourceItemsConfiguration,
        SourceItemConfigurationInterfaceFactory $sourceItemConfigurationInterfaceFactory,
        CollectionFactory $productCollectionFactory,
        Full $indexer
    ) {
        parent::__construct($context);
        $this->sourceItemsSave = $sourceItemsSave;
        $this->sourceItemFactory = $sourceItemFactory;
        $this->sourceItemConfigurationsSave = $sourceItemConfigurationsSave;
        $this->deleteSourceItemsConfiguration = $deleteSourceItemsConfiguration;
        $this->sourceItemConfigurationInterfaceFactory = $sourceItemConfigurationInterfaceFactory;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->indexer = $indexer;
    }

    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Json $resultJson */
        $resultJson = $this->resultFactory->create(\Magento\Framework\Controller\ResultFactory::TYPE_JSON);
        $error = false;
        $messages = [];

        $postItems = $this->getRequest()->getParam('items', []);
        if (!$this->getRequest()->getParam('isAjax') || empty($postItems)) {
            return $resultJson->setData([
                'messages' => [__('Please correct the data sent.')],
                'error' => true,
            ]);
        }

        $sourceItems = [];
        $saveNotifyQty = [];
        $deleteNotifyQty = [];
        if (!empty($postItems) && is_array($postItems)) {
            $mapping = [];
            $productCollection = $this->productCollectionFactory->create();
            $productCollection->getSelect()
                ->reset(Select::COLUMNS)
                ->columns(['entity_id', 'sku']);
            if (isset(end($postItems)['product_id'])) {
                $productIds = [end($postItems)['product_id']];
            } else {
                $productIds = array_keys($postItems);
            }
            $productCollection->addFieldToFilter('entity_id', $productIds);

            foreach ($productCollection->getData() as $item) {
                $mapping[$item['entity_id']] = $item['sku'];
            }

            foreach ($postItems as $entityId => $data) {
                if (isset($data['product_id'])) {
                    $entityId = $data['product_id'];
                }
                if (!isset($data['source_code']) || !isset($mapping[$entityId])) {
                    continue;
                }
                $model = $this->sourceItemFactory->create();
                $model->setStatus(isset($data['source_item_status']) ? (int)$data['source_item_status'] : 1);
                $model->setSourceCode($data['source_code']);
                $model->setQuantity(isset($data['quantity']) ? (float)$data['quantity'] : 0);
                $model->setSku($mapping[$entityId]);

                if (isset($data['notify_stock_qty'])) {
                    $notifyQtyModel = $this->sourceItemConfigurationInterfaceFactory->create();
                    $notifyQtyModel->setSku($model->getSku());
                    $notifyQtyModel->setSourceCode($model->getSourceCode());
                    $notifyQtyModel->setNotifyStockQty((float)$data['notify_stock_qty']);

                    $saveNotifyQty[] = $notifyQtyModel;
                } else {
                    $deleteNotifyQty[] = $model;
                }
                $this->indexer->executeRow($entityId);

                $sourceItems[] = $model;
            }
        }

        if (!empty($sourceItems)) {
            $this->sourceItemsSave->execute($sourceItems);
        }

        if (!empty($deleteNotifyQty)) {
            $this->deleteSourceItemsConfiguration->execute($deleteNotifyQty);
        }

        if (!empty($saveNotifyQty)) {
            $this->sourceItemConfigurationsSave->execute($saveNotifyQty);
        }

        return $resultJson->setData([
            'messages' => $messages,
            'error' => $error
        ]);
    }
}
