<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Controller\Adminhtml\Source;

use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\DB\Select;
use Magento\Framework\Exception\LocalizedException;
use Magento\InventoryApi\Api\Data\SourceItemInterface;

class AssignProducts extends \Magento\Backend\App\Action
{
    public const ADMIN_RESOURCE = 'Magento_InventoryApi::source';

    /**
     * @var \Magento\InventoryApi\Api\SourceItemsSaveInterface
     */
    private $sourceItemsSave;

    /**
     * @var \Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory
     */
    private $sourceItemFactory;

    /**
     * @var \Magento\Ui\Component\MassAction\Filter
     */
    private $filter;

    public function __construct(
        Action\Context $context,
        \Magento\Ui\Component\MassAction\Filter $filter,
        \Magento\InventoryApi\Api\SourceItemsSaveInterface $sourceItemsSave,
        \Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory $sourceItemFactory
    ) {
        parent::__construct($context);
        $this->sourceItemsSave = $sourceItemsSave;
        $this->sourceItemFactory = $sourceItemFactory;
        $this->filter = $filter;
    }

    public function execute()
    {
        $sourceCode = $this->getRequest()->getParam('source_code');
        if (empty($sourceCode)) {
            return $this->resultFactory->create(ResultFactory::TYPE_RAW)->setContents('NE OK');
        }
        $component = $this->filter->getComponent();
        $this->filter->prepareComponent($component);
        try {
            $collection = $this->filter->getCollection($component->getContext()->getDataProvider()->getCollection());
        } catch (LocalizedException $e) {
            return $this->resultFactory->create(ResultFactory::TYPE_RAW)->setContents('NE OK');
        }

        $collection->setPageSize(null);
        $collection->getSelect()
            ->reset(Select::COLUMNS)
            ->columns(['sku']);
        $sourceItems = [];

        foreach ($collection->getData() as $item) {
            $model = $this->sourceItemFactory->create();
            $model->setStatus(SourceItemInterface::STATUS_IN_STOCK);
            $model->setSourceCode($sourceCode);
            $model->setQuantity(0);
            $model->setSku($item['sku']);

            $sourceItems[] = $model;
        }

        if (!empty($sourceItems)) {
            $this->sourceItemsSave->execute($sourceItems);
        }
        return $this->resultFactory->create(ResultFactory::TYPE_RAW)->setContents('OK');
    }
}
