<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Controller\Adminhtml\Import;

use Amasty\AdvancedMSI\Controller\Adminhtml\AbstractImport;

class SourceImport extends AbstractImport
{
    /**
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultFactory->create(\Magento\Framework\Controller\ResultFactory::TYPE_PAGE);
        $resultPage->setActiveMenu('Amasty_AdvancedMSI::source_import');
        $resultPage->getConfig()->getTitle()->prepend(__('Import Sources'));
        $resultPage->addBreadcrumb(__('Import Sources'), __('Import Sources'));

        return $resultPage;
    }
}
