<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Block\Adminhtml\System\Config\Field;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Backend\Block\Template\Context;
use Amasty\AdvancedMSI\Model\SourceSelection\CombinedAlgorithmRegistry;

class CombinedAlgorithmPriority extends Field
{
    public const STOCK_PATH = 'algorithms/';

    public const PRIORITY = 'priority';

    public const IS_ACTIVE = 'is_active';

    /**
     * @var string
     */
    protected $_template = 'Amasty_AdvancedMSI::system/config/form/field/options.phtml';

    /**
     * @var CombinedAlgorithmRegistry
     */
    private $algorithmRegistry;

    public function __construct(
        Context $context,
        CombinedAlgorithmRegistry $algorithmRegistry,
        array $data = []
    ) {
        $this->algorithmRegistry = $algorithmRegistry;
        parent::__construct($context, $data);
    }

    /**
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element
     *
     * @return string
     */
    protected function _getElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $this->setElement($element);

        return $this->_toHtml();
    }

    /**
     * @return array
     */
    public function getDataOptions(): array
    {
        $data = $this->algorithmRegistry->getAll();
        $data = $this->setValues($data);

        return $data;
    }

    /**
     * From Config set parameters with Drag & Drop
     *
     * @param array $data
     * @return array
     */
    private function setValues(array $data): array
    {
        $result = [];
        foreach ($data as $index => $element) {
            $result[$index][self::PRIORITY] = $element->getPriority();
            $result[$index][self::IS_ACTIVE] = (int)$element->getisActive();
            $result[$index]['value'] = $element->getLabel();
        }

        return $result;
    }
}
