<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Api;

/**
 * @api
 */
interface SourceEmailRepositoryInterface
{
    /**
     * Save
     *
     * @param \Amasty\AdvancedMSI\Api\Data\SourceEmailInterface $sourceEmail
     *
     * @return \Amasty\AdvancedMSI\Api\Data\SourceEmailInterface
     */
    public function save(\Amasty\AdvancedMSI\Api\Data\SourceEmailInterface $sourceEmail);

    /**
     * Get by id
     *
     * @param int $sourceEmailId
     *
     * @return \Amasty\AdvancedMSI\Api\Data\SourceEmailInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($sourceEmailId);

    /**
     * Delete
     *
     * @param \Amasty\AdvancedMSI\Api\Data\SourceEmailInterface $sourceEmail
     *
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(\Amasty\AdvancedMSI\Api\Data\SourceEmailInterface $sourceEmail);

    /**
     * Delete by id
     *
     * @param int $sourceEmailId
     *
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($sourceEmailId);

    /**
     * Lists
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Magento\Framework\Api\SearchResultsInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);

    /**
     * @return \Amasty\AdvancedMSI\Api\Data\SourceEmailInterface
     */
    public function getEmptySourceEmailModel();
}
