<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Api;

interface SourceCustomShippingRateRepositoryInterface
{
    /**
     * @param string $sourceCode
     *
     * @return \Amasty\AdvancedMSI\Api\Data\SourceCustomShippingRateInterface[]
     */
    public function getRatesBySourceCode($sourceCode): array;

    /**
     * @param string $sourceCode
     * @param \Amasty\AdvancedMSI\Api\Data\SourceCustomShippingRateInterface[] $sourceCustomShippingRates
     * @return \Amasty\AdvancedMSI\Api\Data\SourceCustomShippingRateInterface[]
     */
    public function save(string $sourceCode, array $sourceCustomShippingRates): array;

    /**
     * @return \Amasty\AdvancedMSI\Api\Data\SourceCustomShippingRateInterface
     */
    public function getEmptySourceCustomShippingRateModel()
        : \Amasty\AdvancedMSI\Api\Data\SourceCustomShippingRateInterface;
}
