<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Api;

use Amasty\AdvancedMSI\Api\Data\ReservedProductsInterface;

interface ReservedProductsRepositoryInterface
{
    /**
     * @param ReservedProductsInterface $reservedProduct
     * @return ReservedProductsInterface
     */
    public function save(ReservedProductsInterface $reservedProduct): ReservedProductsInterface;

    /**
     * @param int $id
     * @return ReservedProductsInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($id): ReservedProductsInterface;

    /**
     * @param int $orderId
     * @return ReservedProductsInterface[]
     */
    public function getByOrderId($orderId): array;

    /**
     * @param ReservedProductsInterface $reservedProduct
     * @return bool
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(ReservedProductsInterface $reservedProduct): bool;

    /**
     * @param int $id
     * @return bool
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($id): bool;

    /**
     * @param int $orderId
     * @return bool
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteByOrderId($orderId): bool;
}
