<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Api\Data;

interface SourceEmailInterface
{
    /**#@+
     * Constants defined for keys of data array
     */
    public const SOURCE_EMAIL_ID = 'source_email_id';
    public const SOURCE_CODE = 'source_code';
    public const EMAIL = 'email';
    public const EMAIL_TYPE = 'email_type';
    /**#@-*/

    /**
     * @return int
     */
    public function getSourceEmailId();

    /**
     * @param int $sourceEmailId
     *
     * @return \Amasty\AdvancedMSI\Api\Data\SourceEmailInterface
     */
    public function setSourceEmailId($sourceEmailId);

    /**
     * @return string
     */
    public function getSourceCode();

    /**
     * @param string $sourceCode
     *
     * @return \Amasty\AdvancedMSI\Api\Data\SourceEmailInterface
     */
    public function setSourceCode($sourceCode);

    /**
     * @return string
     */
    public function getEmail();

    /**
     * @param string $email
     *
     * @return \Amasty\AdvancedMSI\Api\Data\SourceEmailInterface
     */
    public function setEmail($email);

    /**
     * @return string
     */
    public function getEmailType();

    /**
     * @param string $emailType
     *
     * @return \Amasty\AdvancedMSI\Api\Data\SourceEmailInterface
     */
    public function setEmailType($emailType);
}
