<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Api\Data;

use Amasty\AdvancedMSI\Model\SourceCustomShippingRate;

interface SourceCustomShippingRateInterface
{
    /**#@+
     * Constants defined for keys of data array.
     */
    public const SOURCE_CUSTOM_RATE_ID = 'source_custom_rate_id';
    public const SOURCE_CODE = 'source_code';
    public const SHIPPING_RATE_CODE = 'shipping_rate_code';
    public const SHIPPING_RATE = 'shipping_rate';
    /**#@-*/

    /**
     * @return int
     */
    public function getSourceCustomShippingRateId(): int;

    /**
     * @param int $sourceCustomShippingRateId
     *
     * @return \Amasty\AdvancedMsi\Api\Data\SourceCustomShippingRateInterface
     */
    public function setSourceCustomShippingRateId(int $sourceCustomShippingRateId): SourceCustomShippingRateInterface;

    /**
     * @return string
     */
    public function getSourceCode(): string;

    /**
     * @param string $sourceCode
     *
     * @return \Amasty\AdvancedMsi\Api\Data\SourceCustomShippingRateInterface
     */
    public function setSourceCode(string $sourceCode): SourceCustomShippingRate;

    /**
     * @return string
     */
    public function getShippingRateCode(): string;

    /**
     * @param string $shippingRateCode
     *
     * @return \Amasty\AdvancedMsi\Api\Data\SourceCustomShippingRateInterface
     */
    public function setShippingRateCode(string $shippingRateCode): SourceCustomShippingRateInterface;

    /**
     * @return float
     */
    public function getShippingRate(): float;

    /**
     * @param float $shippingRate
     *
     * @return \Amasty\AdvancedMsi\Api\Data\SourceCustomShippingRateInterface
     */
    public function setShippingRate(float $shippingRate): SourceCustomShippingRateInterface;
}
