<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Advanced MSI for Magento 2
 */

namespace Amasty\AdvancedMSI\Api\Data;

interface ReservedProductsInterface
{
    /**#@+
     * Constants defined for keys of data array.
     */
    public const ITEM_ID = 'item_id';
    public const SKU = 'sku';
    public const QUANTITY = 'quantity';
    public const ORDER_ID = 'order_id';
    public const SOURCE_CODE = 'source_code';
    /**#@-*/

    /**
     * @return int
     */
    public function getItemId(): int;

    /**
     * @param int $itemId
     *
     * @return \Amasty\AdvancedMsi\Api\Data\ReservedProductsInterface
     */
    public function setItemId($itemId): ReservedProductsInterface;

    /**
     * @return string
     */
    public function getSku(): string;

    /**
     * @param string $sku
     *
     * @return \Amasty\AdvancedMsi\Api\Data\ReservedProductsInterface
     */
    public function setSku($sku): ReservedProductsInterface;

    /**
     * @return float
     */
    public function getQuantity(): float;

    /**
     * @param float $quantity
     *
     * @return \Amasty\AdvancedMsi\Api\Data\ReservedProductsInterface
     */
    public function setQuantity($quantity): ReservedProductsInterface;

    /**
     * @return int
     */
    public function getOrderId(): int;

    /**
     * @param int $orderId
     *
     * @return \Amasty\AdvancedMsi\Api\Data\ReservedProductsInterface
     */
    public function setOrderId($orderId): ReservedProductsInterface;

    /**
     * @return string
     */
    public function getSourceCode(): string;

    /**
     * @param string $sourceCode
     *
     * @return \Amasty\AdvancedMsi\Api\Data\ReservedProductsInterface
     */
    public function setSourceCode($sourceCode): ReservedProductsInterface;
}
