<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Plugin\Staging\Model\StagingApplier;

use Amasty\AdminActionsLogScheduleUpdate\Model\StagingLoggingProcessor;
use Magento\Staging\Model\StagingApplier;

class LogData
{
    /**
     * @var StagingLoggingProcessor
     */
    private $stagingStorage;

    public function __construct(
        StagingLoggingProcessor $stagingStorage
    ) {
        $this->stagingStorage = $stagingStorage;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeExecute(StagingApplier $subject): void
    {
        $this->stagingStorage->saveEntities();
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterExecute(StagingApplier $subject): void
    {
        $this->stagingStorage->logData();
    }
}
