<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Model;

use Magento\Framework\Module\Manager;
use Magento\Framework\ObjectManagerInterface;
use Magento\Staging\Api\UpdateRepositoryInterface;
use Magento\Staging\Model\ResourceModel\Db\GetNotIndexedEntities;
use Magento\Staging\Model\StagingList;
use Magento\Staging\Model\VersionHistoryInterface;

class StagingObjectFactory
{
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @var Manager
     */
    private $moduleManager;

    /**
     * @var bool
     */
    private $isStagingModuleEnabled;

    public function __construct(
        ObjectManagerInterface $objectManager,
        Manager $moduleManager
    ) {
        $this->objectManager = $objectManager;
        $this->moduleManager = $moduleManager;
    }

    public function isModuleEnabled(): bool
    {
        if (null === $this->isStagingModuleEnabled) {
            $this->isStagingModuleEnabled = $this->moduleManager->isEnabled('Magento_Staging');
        }

        return $this->isStagingModuleEnabled;
    }

    public function getUpdateRepositoryObject(): UpdateRepositoryInterface
    {
        return $this->objectManager->create(UpdateRepositoryInterface::class);
    }

    public function getGetNotIndexedEntitiesObject(): GetNotIndexedEntities
    {
        return $this->objectManager->create(GetNotIndexedEntities::class);
    }

    public function getStagingListObject(): StagingList
    {
        return $this->objectManager->create(StagingList::class);
    }

    public function getVersionHistoryObject(): VersionHistoryInterface
    {
        return $this->objectManager->create(VersionHistoryInterface::class);
    }
}
