<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Logging\Schedule\SaveHandler\Cms;

use Amasty\AdminActionsLog\Api\Logging\MetadataInterface;
use Amasty\AdminActionsLog\Logging\Entity\SaveHandler\Cms\Page as PageSaveHandler;
use Amasty\AdminActionsLog\Model\LogEntry\LogEntry;
use Amasty\AdminActionsLogScheduleUpdate\Model\StagingLoggingProcessor;
use Amasty\AdminActionsLogScheduleUpdate\Plugin\AdminActionsLog\Model\OptionSource\LogEntryTypes\ScheduleOption;

class Page extends PageSaveHandler
{
    public function getLogMetadata(MetadataInterface $metadata): array
    {
        return array_merge(
            parent::getLogMetadata($metadata),
            [
                LogEntry::TYPE => ScheduleOption::TYPE_SCHEDULE,
                LogEntry::USERNAME => StagingLoggingProcessor::UPDATED_BY_SCHEDULE
            ]
        );
    }
}
