<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Logging\Schedule\SaveHandler\Catalog;

use Amasty\AdminActionsLog\Api\Logging\MetadataInterface;
use Amasty\AdminActionsLog\Logging\Entity\SaveHandler\Catalog\Product as ProductSaveHandler;
use Amasty\AdminActionsLog\Model\LogEntry\LogEntry;
use Amasty\AdminActionsLogScheduleUpdate\Model\StagingLoggingProcessor;
use Amasty\AdminActionsLogScheduleUpdate\Plugin\AdminActionsLog\Model\OptionSource\LogEntryTypes\ScheduleOption;

class Product extends ProductSaveHandler
{
    public function getLogMetadata(MetadataInterface $metadata): array
    {
        return array_merge(
            parent::getLogMetadata($metadata),
            [
                LogEntry::TYPE => ScheduleOption::TYPE_SCHEDULE,
                LogEntry::USERNAME => StagingLoggingProcessor::UPDATED_BY_SCHEDULE
            ]
        );
    }
}
