<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Logging\Schedule;

use Amasty\AdminActionsLogScheduleUpdate\Logging\Schedule\Collector\CollectorInterface;
use Magento\Framework\Exception\ConfigurationMismatchException;

class CollectorProvider
{
    /**
     * @var CollectorInterface[]
     */
    private $collectors;

    /**
     * @param CollectorInterface[] $collectorTypes
     */
    public function __construct(
        array $collectorTypes = []
    ) {
        $this->initializeCollectorTypes($collectorTypes);
    }

    public function getCollectorByType(string $type): ?CollectorInterface
    {
        return $this->collectors[$type] ?? null;
    }

    private function initializeCollectorTypes(array $collectorTypes): void
    {
        foreach ($collectorTypes as $type => $collector) {
            if (!$collector instanceof CollectorInterface) {
                throw new ConfigurationMismatchException(
                    __('%1 should implement %2', get_class($collector), CollectorInterface::class)
                );
            }
            $this->collectors[$type] = $collector;
        }
    }
}
