<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Logging\Schedule\Collector;

use Magento\SalesRule\Model\Data\Rule;
use Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory;

class SalesRuleCollector implements CollectorInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        CollectionFactory $collectionFactory
    ) {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param array $entityIds [ 0 => 'entityId', 1 => 'entityId' ]
     *
     * @return \Magento\SalesRule\Model\Rule[]
     */
    public function collect(array $entityIds): array
    {
        $rules = [];
        if (!empty($entityIds)) {
            $rules = $this->collectionFactory->create()
                ->addFieldToFilter(Rule::KEY_RULE_ID, $entityIds)
                ->getItems();
        }

        return $rules;
    }
}
