<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Logging\Schedule\Collector;

use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;

class ProductCollector implements CollectorInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        CollectionFactory $collectionFactory
    ) {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param array $entityIds [ 0 => 'entityId', 1 => 'entityId' ]
     *
     * @return \Magento\Catalog\Api\Data\ProductInterface[]
     */
    public function collect(array $entityIds): array
    {
        $products = [];
        if (!empty($entityIds)) {
            $products = $this->collectionFactory->create()
                ->addIdFilter($entityIds)
                ->addAttributeToSelect('*')
                ->getItems();
        }

        return $products;
    }
}
