<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Logging\Schedule\Collector;

use Magento\Cms\Api\Data\PageInterface;
use Magento\Cms\Model\ResourceModel\Page\CollectionFactory;

class PageCollector implements CollectorInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        CollectionFactory $collectionFactory
    ) {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param array $entityIds [ 0 => 'entityId', 1 => 'entityId' ]
     *
     * @return \Magento\Cms\Api\Data\PageInterface[]
     */
    public function collect(array $entityIds): array
    {
        $pages = [];
        if (!empty($entityIds)) {
            $pages = $this->collectionFactory->create()
                ->addFieldToFilter(PageInterface::PAGE_ID, $entityIds)
                ->getItems();
        }

        return $pages;
    }
}
