<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Logging\Schedule\Collector;

use Magento\CatalogRule\Api\Data\RuleInterface;
use Magento\CatalogRule\Model\ResourceModel\Rule\CollectionFactory;

class CatalogRuleCollector implements CollectorInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        CollectionFactory $collectionFactory
    ) {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param array $entityIds [ 0 => 'entityId', 1 => 'entityId' ]
     *
     * @return \Magento\CatalogRule\Api\Data\RuleInterface[]
     */
    public function collect(array $entityIds): array
    {
        $rules = [];
        if (!empty($entityIds)) {
            $rules = $this->collectionFactory->create()
                ->addFieldToFilter(RuleInterface::RULE_ID, $entityIds)
                ->getItems();
        }

        return $rules;
    }
}
