<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Admin Actions Log Schedule Update
 */

namespace Amasty\AdminActionsLogScheduleUpdate\Logging\Schedule\Collector;

use Magento\Cms\Api\Data\BlockInterface;
use Magento\Cms\Model\ResourceModel\Block\CollectionFactory;

class BlockCollector implements CollectorInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        CollectionFactory $collectionFactory
    ) {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param array $entityIds [ 0 => 'entityId', 1 => 'entityId' ]
     *
     * @return \Magento\Cms\Api\Data\BlockInterface[]
     */
    public function collect(array $entityIds): array
    {
        $blocks = [];
        if (!empty($entityIds)) {
            $blocks = $this->collectionFactory->create()
                ->addFieldToFilter(BlockInterface::BLOCK_ID, $entityIds)
                ->getItems();
        }

        return $blocks;
    }
}
