<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shipping & Payment By Customer Groups for Magento 2
 */

namespace Amasty\Methods\Controller\Adminhtml\Payment;

use Amasty\Methods\Controller\Adminhtml\RegistryConstants;
use Amasty\Methods\Model\Structure\Payment;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;
use Magento\Store\Model\StoreManagerInterface;

class Index extends Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var Registry
     */
    private $coreRegistry;

    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Registry $coreRegistry,
        StoreManagerInterface $storeManager
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->storeManager = $storeManager;
        $this->coreRegistry = $coreRegistry;
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Amasty_Methods::methods_payment');
    }

    /**
     * Index action
     *
     * @return Page
     */
    public function execute()
    {
        $websiteId = $this->getRequest()->getParam('website_id');

        if ($websiteId === null && $this->storeManager->getWebsite()->getId()) {
            $this->_redirect('*/*/*', [
                'website_id' => $this->storeManager->getWebsite()->getId()
            ]);
        } else {
            $structure = $this->_objectManager->create(Payment::class)
                ->load($websiteId);

            $this->coreRegistry->register(
                RegistryConstants::CURRENT_AMASTY_METHODS_PAYMENT,
                $structure
            );

            /** @var Page $resultPage */
            $resultPage = $this->resultPageFactory->create();
            $resultPage->setActiveMenu('Amasty_Methods::methods_payment');
            $resultPage->addBreadcrumb(__('System'), __('System'));
            $resultPage->addBreadcrumb(
                __('Manage Payment Methods Visibility'),
                __('Manage Payment Methods Visibility')
            );
            $resultPage->getConfig()->getTitle()->prepend(__('Payment Methods Visibility'));

            return $resultPage;
        }
    }
}
