<?php

declare(strict_types = 1);

namespace Amasty\MegaMenuPageBuilder\Plugin\Framework\View\Element;

use Amasty\MegaMenu\Model\Menu\Subcategory;
use Magento\Catalog\Model\Category;
use Magento\Framework\View\Element\UiComponentFactory as NativeUiComponentFactory;
use Magento\PageBuilder\Component\Form\Element\Wysiwyg;
use Magento\Store\Model\Store;

class UiComponentFactory
{
    /**
     * @var Subcategory
     */
    private $subcategory;

    /**
     * @var \Magento\Framework\Registry
     */
    private $registry;

    public function __construct(
        \Magento\Framework\Registry $registry,
        Subcategory $subcategory
    ) {
        $this->subcategory = $subcategory;
        $this->registry = $registry;
    }

    /**
     * @param NativeUiComponentFactory $subject
     * @param $result
     *
     * @return mixed
     */
    public function afterCreate(NativeUiComponentFactory $subject, $result)
    {
        if ($result instanceof Wysiwyg) {
            $config = $result->getData('config');
            if (isset($config['wysiwygConfigData']['content_types']['ammega_menu_widget'])
                && ($this->checkWysiwygId($config) || $this->isShowMegaMenu())
            ) {
                unset($config['wysiwygConfigData']['content_types']['ammega_menu_widget']);
                $result->setData('config', $config);
            }
        }

        return $result;
    }

    private function checkWysiwygId(array $config): bool
    {
        return !isset($config['wysiwygId']) || $config['wysiwygId'] !== 'category_form_content';
    }

    private function isShowMegaMenu(): bool
    {
        /** @var Category $category */
        $category = $this->registry->registry('category');
        if (!$category) {
            return false;
        }
        $parentCategory = $this->getParentCategory($category, Subcategory::TOP_LEVEL);

        return $parentCategory && $this->subcategory->isShowSubcategories(
            (int) $parentCategory->getLevel(),
            (int) $parentCategory->getEntityId(),
            (int) ($parentCategory->getStoreId() ?? Store::DEFAULT_STORE_ID)
        );
    }

    private function getParentCategory($category, int $level)
    {
        if ($category->getLevel() > $level) {
            $category = $this->getParentCategory($category->getParentCategory(), $level);
        }

        return $category;
    }
}
