<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Mega Menu GraphQl for Magento 2 (System)
 */

use Magento\TestFramework\Helper\Bootstrap;
use \Magento\Framework\View\Design\ThemeInterface;
use Magento\Widget\Model\ResourceModel\Widget\Instance as ResourceInstance;
use \Magento\Widget\Model\Widget\Instance as ModelInstance;

/** @var ResourceInstance $resourceModel */
$resourceModel = Bootstrap::getObjectManager()->get(ResourceInstance::class);

/** @var ModelInstance $model */
$model = Bootstrap::getObjectManager()->get(ModelInstance::class);

/** @var ThemeInterface $theme */
$theme = Bootstrap::getObjectManager()->create(ThemeInterface::class);

$theme->load('Magento/luma', 'theme_path');

$model->setData(
    [
        'instance_type' => 'Amasty\\MegaMenu\\Block\\Product\\ProductsSlider',
        'instance_code' => 'new_megamenu_slider_test_widget',
        'theme_id' => $theme->getId(),
        'title' => 'New Mega Menu Slider Test Widget title',
        'store_ids' => [
            0 => '0',
        ],
        'widget_parameters' => [
            'block_layout' => 'slider',
            'slider_items_show' => '3',
            'slider_width' => '120',
            'slider_autoplay' => '1',
            'slider_autoplay_speed' => '12',
            'display_options' => '1',
            'products_count' => '5',
            'conditions' => [
                '1' => [
                    'type' => 'Magento\\CatalogWidget\\Model\\Rule\\Condition\\Combine',
                    'aggregator' => 'all',
                    'value' => '1'
                ]
            ],
        ],
        'sort_order' => '0'
    ]
);

$resourceModel->save($model);
