<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Mega Menu GraphQl for Magento 2 (System)
 */

use Amasty\MegaMenu\Api\ItemRepositoryInterface;
use Amasty\MegaMenu\Api\LinkRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var ItemRepositoryInterface $itemRepository */
$itemRepository = $objectManager->get(ItemRepositoryInterface::class);

/** @var LinkRepositoryInterface $linkRepository */
$linkRepository = $objectManager->get(LinkRepositoryInterface::class);

/** @var SearchCriteriaBuilder $searchCriteria */
$searchCriteria = Bootstrap::getObjectManager()->create(SearchCriteriaBuilder::class);

$searchCriteriaLink = $searchCriteria
    ->addFilter('link', 'amasty_link.html')
    ->addFilter('name', 'Test Name Mega Menu Custom Item')
    ->create();
$items = $itemRepository->getList($searchCriteriaLink)->getItems();

foreach ($items as $item) {
    $link = $linkRepository->getById($item->getEntityId());
    $linkRepository->delete($link);
}
