<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Mega Menu GraphQl for Magento 2 (System)
 */

use Amasty\MegaMenu\Api\ItemRepositoryInterface;
use Amasty\MegaMenu\Api\LinkRepositoryInterface;
use Amasty\MegaMenu\Model\Menu\Item;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var ItemRepositoryInterface $itemRepository */
$itemRepository = $objectManager->get(ItemRepositoryInterface::class);

/** @var LinkRepositoryInterface $linkRepository */
$linkRepository = $objectManager->get(LinkRepositoryInterface::class);

$newLink = $linkRepository->getNew();

$newLink->setLevel(0);
$newLink->setPath("0");
$newLink->setParentId(0);

$linkRepository->save($newLink);

$entityId = $newLink->getEntityId();

$item = $itemRepository->getNew();
$item->setColumnCount(2);
$item->setDesktopFont(12);
$item->setStatus(1);
$item->setStoreId(0);
$item->setHideContent(true);
$item->setIcon('icon');
$item->setMobileFont(10);
$item->setName('Test Name Mega Menu Custom Item');
$item->setLabel('Test Label Mega Menu Custom Item');
$item->setLabelBackgroundColor('#573f3f');
$item->setLabelTextColor('#aa3b3b');
$item->setSubcategoriesPosition(1);
$item->setSubmenuType(0);
$item->setWidth(2);
$item->setWidthValue(90);
$item->setType(Item::CUSTOM_TYPE);
$item->setLink('amasty_link.html');
$item->setLinkType(1);
$item->setEntityId($entityId);

$itemRepository->save($item);
