<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Mega Menu GraphQl for Magento 2 (System)
 */

use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\CatalogRule\Model\Indexer\IndexBuilder;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\TestFramework\Catalog\Model\GetCategoryByName;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Framework\Registry;

$objectManager = Bootstrap::getObjectManager();

/** @var GetCategoryByName $getCategoryByName */
$getCategoryByName = $objectManager->create(GetCategoryByName::class);

/** @var CategoryRepositoryInterface $categoryRepository */
$categoryRepository = $objectManager->get(CategoryRepositoryInterface::class);

/** @var  IndexBuilder $indexBuilder */
$indexBuilder = $objectManager->get(IndexBuilder::class);

/** @var Registry $registry */
$registry = $objectManager->get(\Magento\Framework\Registry::class);
$registry->unregister('isSecureArea');
$registry->register('isSecureArea', true);

$categoryParent = $getCategoryByName->execute('Special Mega Menu Categ Parent');
$categoryChild = $getCategoryByName->execute('Special Mega Menu Categ Child');

try {
    $categoryRepository->delete($categoryParent);
    $categoryRepository->delete($categoryChild);
} catch (NoSuchEntityException $e) {
    //category already deleted.
}

$indexBuilder->reindexFull();

$registry->unregister('isSecureArea');
$registry->register('isSecureArea', false);
