<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Mega Menu GraphQl for Magento 2 (System)
 */

use Magento\TestFramework\Helper\Bootstrap;
use Magento\Catalog\Api\Data\CategoryInterfaceFactory;

$objectManager = Bootstrap::getObjectManager();

/** @var  CategoryInterfaceFactory $categoryFactory */
$categoryFactory = $objectManager->get(CategoryInterfaceFactory::class);

$categoryOne = $categoryFactory->create();
$categoryOne->isObjectNew(true);
$categoryOne->setName('Special Mega Menu Categ Parent')
    ->setParentId(2)
    ->setPath('1/2')
    ->setLevel(2)
    ->setAvailableSortBy('name')
    ->setDefaultSortBy('name')
    ->setIsActive(true)
    ->setPosition(1)
    ->setDescriptio('Special Mega Menu Categ Parent description')
    ->save();

$idParent = $categoryOne->getId();

$categoryTwo = $categoryFactory->create();
$categoryTwo->isObjectNew(true);
$categoryTwo->setName('Special Mega Menu Categ Child')
    ->setParentId($idParent)
    ->setLevel(3)
    ->setPath('1/2/' . $idParent)
    ->setAvailableSortBy('name')
    ->setDefaultSortBy('name')
    ->setIsActive(true)
    ->setIsAnchor(true)
    ->setPosition(1)
    ->setDescription('Special Mega Menu Categ Child description.')
    ->save();
