<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Mega Menu GraphQl for Magento 2 (System)
 */

namespace Amasty\MegaMenuGraphQl\Test\GraphQl;

use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;
use Magento\Widget\Model\ResourceModel\Widget\Instance\CollectionFactory;

class GetAmMegaMenuWidgetTest extends GraphQlAbstract
{
    public const MAIN_RESPONSE_KEY = 'amMegaMenuWidget';
    public const ITEMS_RESPONSE_KEY = 'items';

    /** @var CollectionFactory  */
    private $collectionFactory;

    protected function setUp(): void
    {
        parent::setUp();

        $this->collectionFactory = Bootstrap::getObjectManager()->get(CollectionFactory::class);
    }

    /**
     * @group amasty_megamenu
     *
     * @magentoApiDataFixture Amasty_MegaMenuGraphQl::Test/GraphQl/_files/new_widget_grid.php
     * @magentoApiDataFixture Amasty_MegaMenuGraphQl::Test/GraphQl/_files/new_widget_slider.php
     */
    public function testAmMegaMenuWidget()
    {
        $widgetGridTitle = 'New Mega Menu Grid Test Widget title';
        $widgetSliderTitle = 'New Mega Menu Slider Test Widget title';

        $widgetGrid = $this->collectionFactory->create()->addFieldToFilter(
            'title',
            $widgetGridTitle
        )->getFirstItem();
        $widgetGridExpectValues = [
            'block_layout' => 'grid',
            'display_options' => 'true',
            'products_count' => 5,
            'products_per_page' => 10,
            'show_pager' => true,
        ];

        $widgetSlider = $this->collectionFactory->create()->addFieldToFilter(
            'title',
            $widgetSliderTitle
        )->getFirstItem();
        $widgetSliderExpectValues = [
            'block_layout' => 'slider',
            'display_options' => 'true',
            'products_count' => 5,
            'show_pager' => false,
            'slider_autoplay' => true,
            'slider_autoplay_speed' => 12,
            'slider_items_show' => 3,
            'slider_width' => 120
        ];

        // get response for widget grid type
        $responseGrid = $this->graphQlQuery($this->getQuery((int)$widgetGrid->getId()));

        // assert main response key and fields values
        $this->assertArrayHasKey(self::MAIN_RESPONSE_KEY, $responseGrid);
        $this->assertArrayHasKey(self::ITEMS_RESPONSE_KEY, $responseGrid[self::MAIN_RESPONSE_KEY]);

        // assert additional response keys and fields values
        $this->assertResponseFields($responseGrid[self::MAIN_RESPONSE_KEY], $widgetGridExpectValues);
        $this->assertNull($responseGrid[self::MAIN_RESPONSE_KEY]['slider_autoplay']);
        $this->assertNull($responseGrid[self::MAIN_RESPONSE_KEY]['title']);

        // get response for widget slider type
        $responseSlider = $this->graphQlQuery($this->getQuery((int)$widgetSlider->getId()));

        // assert main response key and fields values
        $this->assertArrayHasKey(self::MAIN_RESPONSE_KEY, $responseSlider);
        $this->assertArrayHasKey(self::ITEMS_RESPONSE_KEY, $responseSlider[self::MAIN_RESPONSE_KEY]);

        // assert additional response keys and fields values
        $this->assertResponseFields($responseSlider[self::MAIN_RESPONSE_KEY], $widgetSliderExpectValues);
        $this->assertNull($responseSlider[self::MAIN_RESPONSE_KEY]['products_per_page']);
        $this->assertNull($responseSlider[self::MAIN_RESPONSE_KEY]['title']);
    }

    /**
     * @param int $widgetId
     * @return string
     */
    private function getQuery(int $widgetId): string
    {
        return <<<QUERY
query {
  amMegaMenuWidget(id: $widgetId) {
    block_layout
    display_options
    items{
      name
    }
    products_count
    products_per_page
    show_pager
    slider_autoplay
    slider_autoplay_speed
    slider_items_show
    slider_width
    title
  }
}
QUERY;
    }
}
