<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Preparer;

use Amasty\JetThemeSampleData\Setup\PreparerInterface;
use Magento\Framework\App\Config;
use Magento\Framework\App\ResourceConnection;
use Magento\Store\Api\WebsiteRepositoryInterface;
use Magento\Store\Model\ResourceModel\Website\CollectionFactory;

class Website implements PreparerInterface
{
    const DEFAULT_WEBSITE_CODE = 'base';

    /**
     * @var ResourceConnection
     */
    private $resource;

    /**
     * @var CollectionFactory
     */
    private $websiteCollectionFactory;

    /**
     * @var WebsiteRepositoryInterface
     */
    private $websiteRepository;

    /**
     * @var Config
     */
    private $config;

    public function __construct(
        ResourceConnection $resource,
        CollectionFactory $websiteCollectionFactory,
        WebsiteRepositoryInterface $websiteRepository,
        Config $config
    ) {
        $this->resource = $resource;
        $this->websiteCollectionFactory = $websiteCollectionFactory;
        $this->websiteRepository = $websiteRepository;
        $this->config = $config;
    }

    /**
     * @return void
     */
    public function prepare(): void
    {
        $this->prepareWebsite();
    }

    /**
     * @return void
     */
    private function prepareWebsite(): void
    {
        $select = $this->resource->getConnection()
            ->select()
            ->from($this->resource->getTableName('store_website'))
            ->where("code = '" . self::DEFAULT_WEBSITE_CODE . "'");

        $website = $select->getConnection()->fetchCol($select);
        if ($website) {
            return;
        }

        $website = $this->websiteCollectionFactory->create()
            ->addFieldToFilter('code', ['neq' => 'admin'])
            ->getFirstItem();

        $website->setData('code', self::DEFAULT_WEBSITE_CODE);
        $website->save();
        $this->websiteRepository->clean();
        $this->config->clean();
    }
}
