<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Preparer;

use Amasty\JetThemeSampleData\Setup\PreparerInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Store\Model\ResourceModel\Website\CollectionFactory;

class Tax implements PreparerInterface
{
    const DEFAULT_CLASS_NAME = 'Taxable Goods';
    const DEFAULT_CLASS_TYPE = 'PRODUCT';

    /**
     * @var ResourceConnection
     */
    private $resource;

    public function __construct(
        ResourceConnection $resource
    ) {
        $this->resource = $resource;
    }

    /**
     * @return void
     */
    public function prepare(): void
    {
        $this->createTaxClass();
    }

    /**
     * @return void
     */
    private function createTaxClass(): void
    {
        $select = $this->resource->getConnection()
            ->select()
            ->from($this->resource->getTableName('tax_class'))
            ->where("class_name = '" . self::DEFAULT_CLASS_NAME . "'");

        $taxClass = $select->getConnection()->fetchCol($select);
        if ($taxClass) {
            return;
        }

        $this->resource->getConnection()->insert(
            $this->resource->getTableName('tax_class'),
            [
                'class_name' => self::DEFAULT_CLASS_NAME,
                'class_type' => self::DEFAULT_CLASS_TYPE,
            ]
        );
    }
}
