<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Preparer;

use Amasty\JetThemeSampleData\Setup\PreparerInterface;
use Magento\Framework\App\ResourceConnection;

class ProductTabs implements PreparerInterface
{
    /**
     * @var ResourceConnection
     */
    private $resource;

    public function __construct(ResourceConnection $resource)
    {
        $this->resource = $resource;
    }

    /**
     * @return void
     */
    public function prepare(): void
    {
        $this->clearTables();
    }

    /**
     * @return void
     */
    private function clearTables(): void
    {
        if ($this->resource->getConnection()->isTableExists(
            $this->resource->getTableName('amasty_customtabs_tabs_store')
        )) {
            $this->resource->getConnection()->truncateTable(
                $this->resource->getTableName('amasty_customtabs_tabs_store')
            );
        }

        if ($this->resource->getConnection()->isTableExists(
            $this->resource->getTableName('amasty_customtabs_tabs_rule_index')
        )) {
            $this->resource->getConnection()->truncateTable(
                $this->resource->getTableName('amasty_customtabs_tabs_rule_index')
            );
        }

        if ($this->resource->getConnection()->isTableExists(
            $this->resource->getTableName('amasty_customtabs_tabs')
        )) {
            $this->resource->getConnection()->delete(
                $this->resource->getTableName('amasty_customtabs_tabs')
            );
        }
    }
}
