<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Preparer;

use Amasty\JetThemeSampleData\Setup\PreparerInterface;
use Magento\Framework\App\ResourceConnection;

class Import implements PreparerInterface
{
    /**
     * @var ResourceConnection
     */
    private $resource;

    /**
     * @param ResourceConnection $resource
     */
    public function __construct(ResourceConnection $resource)
    {
        $this->resource = $resource;
    }

    /**
     * @return void
     */
    public function prepare(): void
    {
        $this->clearImportTables();
    }

    /**
     * @return void
     */
    private function clearImportTables(): void
    {
        if ($this->resource->getConnection()->isTableExists(
            $this->resource->getTableName('import_history')
        )) {
            $this->resource->getConnection()->truncateTable($this->resource->getTableName('import_history'));
        }
        if ($this->resource->getConnection()->isTableExists(
            $this->resource->getTableName('importexport_importdata')
        )) {
            $this->resource->getConnection()->truncateTable(
                $this->resource->getTableName('importexport_importdata')
            );
        }
    }
}
