<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Preparer;

use Amasty\JetThemeSampleData\Setup\PreparerInterface;
use Magento\Framework\App\ResourceConnection;

class Cms implements PreparerInterface
{
    /**
     * @var ResourceConnection
     */
    private $resource;

    /**
     * @param ResourceConnection $resource
     */
    public function __construct(ResourceConnection $resource)
    {
        $this->resource = $resource;
    }

    /**
     * @return void
     */
    public function prepare(): void
    {
        $this->removeAllStaticBlocks();
        $this->removeAllStaticPages();
        $this->removeAllWidgets();
    }

    /**
     * @return void
     */
    private function removeAllStaticBlocks(): void
    {
        $this->resource->getConnection()->delete($this->resource->getTableName('cms_block'));
    }

    /**
     * @return void
     */
    private function removeAllStaticPages(): void
    {
        $this->resource->getConnection()->delete($this->resource->getTableName('cms_page'));
    }

    /**
     * @return void
     */
    private function removeAllWidgets(): void
    {
        $this->resource->getConnection()->delete($this->resource->getTableName('widget_instance'));
    }
}
