<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Preparer;

use Amasty\JetThemeSampleData\Setup\PreparerInterface;
use Magento\Framework\App\ResourceConnection;

class Catalog implements PreparerInterface
{
    /**
     * @var ResourceConnection
     */
    private $resource;

    /**
     * @param ResourceConnection $resource
     */
    public function __construct(ResourceConnection $resource)
    {
        $this->resource = $resource;
    }

    /**
     * @return void
     */
    public function prepare(): void
    {
        $this->removeAllProducts();
        $this->removeAllCategories();
        $this->removeColorAttribute();
    }

    /**
     * @return void
     */
    private function removeAllProducts(): void
    {
        $this->resource->getConnection()->delete($this->resource->getTableName('catalog_product_entity'));
    }

    /**
     * @return void
     */
    private function removeAllCategories(): void
    {
        $this->resource->getConnection()->delete(
            $this->resource->getTableName('catalog_category_entity'),
            "path NOT IN ('1', '1/2')"
        );
    }

    /**
     * @return void
     */
    private function removeColorAttribute(): void
    {
        $this->resource->getConnection()->delete(
            $this->resource->getTableName('eav_attribute'),
            "attribute_code = 'color'"
        );
    }
}
