<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup;

use Exception;

class Prepare
{
    /**
     * @var PreparerInterface[]
     */
    private $preparerList;

    /**
     * @param PreparerInterface[] $preparerList
     */
    public function __construct(array $preparerList = [])
    {
        $this->preparerList = $preparerList;
    }

    /**
     * @return void
     */
    public function prepare(): void
    {
        $preparerList = $this->getPreparerList();

        foreach ($preparerList as $preparer) {
            $preparer->prepare();
        }
    }

    /**
     * @return PreparerInterface[]
     * @throws Exception
     */
    private function getPreparerList(): array
    {
        $preparerList = [];
        usort($this->preparerList, [$this, 'compare']);
        foreach ($this->preparerList as $preparerKey => $preparerData) {
            if (!is_array($preparerData) || !array_key_exists('preparer', $preparerData)) {
                throw new Exception('Preparer Must have installer Property.');
            }

            $preparer = $preparerData['preparer'] ?? null;
            if (!$preparer instanceof PreparerInterface) {
                throw new Exception('Preparer Class Must Implement InstallerInterface.');
            }

            $preparerList[] = $preparer;
        }

        $this->preparerList = $preparerList;

        return $this->preparerList;
    }

    /**
     * @param array $a
     * @param array $b
     *
     * @return int
     */
    private function compare(array $a, array $b): int
    {
        $aOrder = (int)($a['order'] ?? 0);
        $bOrder = (int)($b['order'] ?? 0);

        return $aOrder <=> $bOrder;
    }
}
